# week05_06_chap04_09.py

class Node:
    def __init__(self):
        self.data = None
        self.link = None


def print_nodes(start):
    current = start
    if current is None:  # 출력할 노드가 없으면
        return

    print(current.data, end=' ')
    while current.link is not None:
        current = current.link  # 가르키는 대상 변경(증가)
        print(current.data, end=' ')
    print()


def insert_node(find_data, insert_data):
    global head, current, pre

    if head.data == find_data:
        node = Node()
        node.data = insert_data
        node.link = head
        head = node
        return

    current = head
    while current.link is not None:
        pre = current
        current = current.link
        if current.data == find_data:
            node = Node()
            node.data = insert_data
            node.link = current
            pre.link = node
            return

    node = Node()
    node.data = insert_data
    current.link = node


def delete_node(delete_data):
    global head, current, pre

    if head.data == delete_data:
        current = head
        head = head.link
        del current
        print('첫 번째 노드가 삭제되었습니다')
        return

    current = head
    while current.link is not None:
        pre = current
        current = current.link
        if current.data == delete_data:
            pre.link = current.link
            del current
            print('첫 번째 이후 노드가 삭제되었습니다')
            return

    print('삭제된 노드가 없습니다')


def find_node(find_data):
    global head, current

    current = head
    if current.data == find_data:
        return current
    while current.link is not None:
        current = current.link
        if current.data == find_data:
            return current

    return Node()  # 찾는 노드가 없음


def make_simple_linked_list(name_phone):
    global head, current, pre
    print_nodes(head)

    node = Node()
    node.data = name_phone

    if head is None:			# 첫 번째 노드일 때
        head = node
        return

    if head.data[0] > name_phone[0]: # 첫 번째 노드보다 작을 때
        node.link = head
        head = node
        return

    current = head
    while current.link is not None:
        pre = current
        current = current.link
        if current.data[0] > name_phone[0]:
            pre.link = node
            node.link = current
            return

    current.link = node


head, current, pre = None, None, None
data_array = [
    ["지민", "010-1111-1111"],
    ["정국", "010-2222-2222"],
    ["뷔", "010-3333-3333"],
    ["슈가", "010-4444-4444"],
    ["진", "010-5555-5555"]
]


if __name__ == "__main__":
    for data in data_array:
        make_simple_linked_list(data)

    print_nodes(head)


    