package com.springboot.validator;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import java.lang.annotation.Target;
import jakarta.validation.Constraint;
import jakarta.validation.Payload;

@Constraint(validatedBy = BookIdValidator.class)
@Target({ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface BookId {
    // 이 부분이 중요합니다! messages.properties 파일의 키와 일치해야 합니다.
    String message() default "{BookID.book.bookID}"; 
    Class<?>[] groups() default {};
    Class<? extends Payload>[] payload() default {};
}
	