package com.springboot.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.springboot.domain.Book;
import com.springboot.domain.Order;
import com.springboot.repository.BookRepository;
import com.springboot.repository.OrderRepository;

@Service
public class OrderServiceImpl implements OrderService {
    @Autowired
    private BookRepository bookRepository;
    @Autowired
    private OrderRepository orderRepository; // In-memory Repository 참조

    public void confirmOrder (String bookId, long quantity) { // 도서 재고 수 처리 메서드
    	Book bookById = bookRepository.findByBookId(bookId);
        if (bookById.getUnitsInStock() < quantity) {
            throw new IllegalArgumentException("품절입니다. 사용 가능한 재고수:" + bookById.getUnitsInStock());
        }
        bookById.setUnitsInStock (bookById.getUnitsInStock()-quantity);
    }

    public Long saveOrder (Order order) { // 주문 목록 저장 메서드
        Long orderId = orderRepository.saveOrder(order);
        return orderId;
    }
}