package com.springboot.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.springboot.domain.Order;
import com.springboot.repository.OrderProRepository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

@Service
public class OrderProService {
    @Autowired
    private OrderProRepository orderProRepository;

    public void save (Order order) { // 주문 정보를 데이터베이스 테이블에 저장
        orderProRepository.save(order); //
    }

    // 주문 목록 페이지에서 선택한 필드를 정렬 방식에 따라 출력함
    public Page<Order> listAll(int pageNum, String sortField, String sortDir) {
        int pageSize = 5;
        Pageable pageable = PageRequest.of(pageNum - 1, pageSize, sortDir.equals("asc") ? Sort.by(sortField).ascending() : Sort.by(sortField).descending());
        return orderProRepository.findAll(pageable);
    }

    // 설정한 id의 주문 정보를 조회하여 가져옴
    public Order get(Long id) {
        return orderProRepository.findById(id).get();
    }

    // 설정한 id의 주문 정보를 삭제함
    public void delete(Long id) {
        orderProRepository.deleteById(id);
    }

    // 모든 주문 목록을 삭제함
    public void deleteAll() {
        orderProRepository.deleteAll();
    }
}