package com.springboot.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.HashSet;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.springboot.domain.Book;
import com.springboot.repository.BookRepository;
import com.springboot.exception.BookIdException;

@Service
public class BookServiceImpl implements BookService {

    @Autowired
    private BookRepository bookRepository; // JPA Repository 

    @Override
    public List<Book> getAllBookList() {
        return bookRepository.findAll(); // JPA findAll 
    }

    public Book getBookById(String bookId) {
        return bookRepository.findById(bookId)
                             .orElseThrow(() -> new BookIdException(bookId));
    }

    public List<Book> getBookListByCategory(String category) {
        return bookRepository.findByCategory(category); 
    }

    public Set<Book> getBookListByFilter(Map<String, List<String>> filter) {
        Set<Book> booksByPublisher = new HashSet<>();
        Set<Book> booksByCategory = new HashSet<>();

        List<String> publishers = filter.get("publisher");
        if (publishers != null && !publishers.isEmpty()) {
            for (String publisherName : publishers) {
                booksByPublisher.addAll(bookRepository.findAll().stream()
                                            .filter(book -> publisherName.equalsIgnoreCase(book.getPublisher()))
                                            .collect(Collectors.toSet()));
            }
        }

        List<String> categories = filter.get("category");
        if (categories != null && !categories.isEmpty()) {
            for (String category : categories) {
                booksByCategory.addAll(bookRepository.findByCategory(category));
            }
        }

       
        if (!booksByPublisher.isEmpty() && !booksByCategory.isEmpty()) {
            booksByCategory.retainAll(booksByPublisher);
            return booksByCategory;
        } else if (!booksByPublisher.isEmpty()) {
            return booksByPublisher;
        } else if (!booksByCategory.isEmpty()) {
            return booksByCategory;
        } else {
            return new HashSet<>();
        }
    }

    public void setNewBook(Book book) {
        bookRepository.save(book); 
    }

    public void setUpdateBook (Book book) {
        bookRepository.save(book);
    }

    public void setDeleteBook (String bookID) {
        bookRepository.deleteById(bookID); // JPA deleteById 사용
    }
}
