package com.springboot.domain;

import java.time.LocalDateTime;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.AccessLevel;

@Getter
@NoArgsConstructor(access = AccessLevel.PUBLIC)
public class Board {
    private Long id; 

    private String writerid; 
    private String writer; 
    private String title; 
    private String content; 

    private LocalDateTime createdDate; 

    
    private LocalDateTime modifiedDate; 

    @Builder
    public Board(Long id, String writerid, String writer, String title, String content, LocalDateTime createdDate, LocalDateTime modifiedDate) { 
        this.id = id; 
        this.writerid = writerid; 
        this.writer = writer; 
        this.title = title; 
        this.content = content; 
        this.createdDate = createdDate; 
        this.modifiedDate = modifiedDate; 
    }

    // JDBC 연동을 위해 Setter 추가
    public void setId(Long id) { this.id = id; }
    public void setWriterid(String writerid) { this.writerid = writerid; }
    public void setWriter(String writer) { this.writer = writer; }
    public void setTitle(String title) { this.title = title; }
    public void setContent(String content) { this.content = content; }
    public void setCreatedDate(LocalDateTime createdDate) { this.createdDate = createdDate; }
    public void setModifiedDate(LocalDateTime modifiedDate) { this.modifiedDate = modifiedDate; }
}