package com.springboot.controller;

import org.springframework.stereotype.Controller;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.User;
import org.springframework.ui.Model;
import com.springboot.domain.Member;
import com.springboot.service.MemberService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;

@Controller
public class HomeController {
    @Autowired
    private MemberService memberService;

    // 웹 요청 URL이 /인 경우에 호출하는 메서드
    @RequestMapping("/")
    public String welcome (Model model, Authentication authentication, HttpServletRequest httpServletRequest) { //
        if (authentication == null || !authentication.isAuthenticated() || "anonymousUser".equals(authentication.getPrincipal())) { //
            // 인증 전 처리 또는 익명 사용자일 경우
            return "welcome"; //
        }

        // 인증 후 처리
        Object principal = authentication.getPrincipal(); //
        if (principal instanceof User) { //
            User user = (User) principal; //
            String userId = user.getUsername(); //
            Member member = memberService.getMemberById(userId); //

            if(member == null) {
                // DB에 없는 사용자일 경우 (예: Admin 계정은 InMemoryUserDetailsManager에만 있을 때)
                return "redirect:/login"; // 로그인 페이지로 리다이렉트 또는 에러 처리
            }

            HttpSession session = httpServletRequest.getSession(true); //
            session.setAttribute("userLoginInfo", member); // 사용자 정보의 세션 등록
            return "welcome"; //
        }
        return "welcome"; // 그 외 경우
    }
}