package com.springboot.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;
import lombok.AllArgsConstructor;

@Configuration
@EnableWebSecurity
@AllArgsConstructor
public class SecurityConfig {
    @Bean
    protected PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    /* @Bean // MemberService가 UserDetailsService를 구현하므로 이 부분은 주석 처리 또는 삭제
    protected UserDetailsService users() {
        UserDetails admin = User.builder()
        .username("Admin")
        .password (passwordEncoder().encode("Admin1234"))
        .roles ("ADMIN")
        .build();
        return new InMemoryUserDetailsManager(admin);
    } */

    @Bean
    protected SecurityFilterChain filterChain (HttpSecurity http) throws Exception {
        http
        .csrf (AbstractHttpConfigurer::disable)
        .authorizeHttpRequests (
            authorizeRequests -> authorizeRequests
            .requestMatchers("/books/add").hasRole("ADMIN")
            .requestMatchers("/order/list").hasRole("ADMIN") // 주문 목록 경로는 ADMIN 권한 필요
            .anyRequest().permitAll()
        )
        .formLogin(
            formLogin -> formLogin
            .loginPage("/login")
            .loginProcessingUrl("/login")
            .defaultSuccessUrl("/order/list") // 관리자 로그인 성공 후 주문 목록 페이지로 이동
            .failureUrl("/loginfailed")
            .usernameParameter("username")
            .passwordParameter("password")
        )
        .logout(
            logout -> logout
            .logoutUrl("/logout")
            .logoutSuccessUrl("/login")
        );
        return http.build();
    }
}
