<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<%@ page import = "bbs.BbsDAO" %>
<%@ page import = "bbs.Bbs" %>
<%@ page import = "java.util.ArrayList" %>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>My House is Tamboru</title>
<style>
        /* 스타일링을 위한 CSS 코드 */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        header {
            background-color: white;
            color: white;
            padding: 7px;
            text-align: right;
        }
        header a {
            color: #000;
            text-decoration: none;
            margin-left: 8px;
            font-size: 10px;
        }
    </style>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
</head>
<body>
	<% 
		String userID = null;
		if (session.getAttribute("userID") != null) {
			userID = (String) session.getAttribute("userID");
		}
		int pageNumber = 1;
		if (request.getParameter("pageNumber") != null) {
			pageNumber = Integer.parseInt(request.getParameter("pageNumber"));
		}
	%>
	<!-- 위의 헤더 -->
	<header>
	    <!-- 로그인 여부에 따라 다르게 표시 -->
	    <%	if(userID == null) { %>
	        <a href="login.jsp">로그인</a>
	        
	     <% }else {%>
	     	<a href="main.jsp">집주인님 어서오세요</a>
	        <a href="logoutAction.jsp">로그아웃</a>
	     <%}%>
	    &nbsp;&nbsp;&nbsp;
	</header>
	<div class="container">
    	<div class="row align-items-center flex-row">
			<div class="col-md-12">
				<img src="./ddr/Past.png" class="img-fluid" alt="로고 이미지 손상 style ="height: 100px; aspect-ratio: 4/1;">
			</div>
		</div>
	</div>
	<br>
	
	<!-- 로고와 검색창 -->
	<div class="container">
    	<div class="row align-items-start flex-row">
    	<!-- align-items-center은 로고와 검색창 위아래정렬 flex-row는 검색 단어 가로쓰기 변경-->
        	<div class="col-md-2">
            	<!-- 상위구획 1 : 검색창 -->
            	<form action="search.jsp" method="post" class="d-flex" role="search">
      				<input class="form-control me-2" type="search" placeholder="Search" aria-label="Search" name="sear">
      				<button class="btn btn-outline-primary" type="submit">
      					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-search" viewBox="0 0 16 16">
  						<path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
						</svg>
      				</button>
    			</form>
    			
    			<!-- 상위구획 2 : 게시판 선택 -->
    			<div style=" border-radius: 8px; border: 1px solid #dddddd; padding: 3px; text-align: right;">
	           	<nav class="nav nav-pills text-center" style="border-radius: 8px; border: 1px solid #0d6efd; padding: 3px; background-color: #0d6efd;">
	           	  <a style="color: white;">게시판</a><br>
				</nav>
				<div class="brand-box ">
                <a href="main.jsp" class="brand-link" style="color:black; margin-right:5pt; text-decoration: none;">전체게시판</a>
            	</div>
            	<div class="brand-box">
                <a href="csound.jsp" class="brand-link" style="color: black; margin-right:5pt; text-decoration: none;">코딩게시판</a>
            	</div>
            	<div class="brand-box">
                <a href="ssound.jsp" class="brand-link" style="color: black; margin-right:5pt; text-decoration: none;">잡담게시판</a>
            	</div>
            	<% if(userID != null) { %>
	           	<!-- 브랜드 -->
                <a href="bsound.jsp" class="brand-link" style="font-weight: bold; color: black; margin-right:5pt; text-decoration: none;">비밀게시판</a>
                <%} %>
            	</div>
            	<% if(userID != null) { %>
            	<br>
            	<!-- 상위구획 3 : 글쓰기 -->
            	<form  action="write.jsp" method="post">
            	<button type="submit" class="btn btn-outline-info col-md-12">글쓰기</button>
            	</form>
            	<%} %>
            </div>
        	<div class="col-md-10" style=" border-radius: 8px; border: 1px solid #dddddd; padding: 3px; text-align: right;">
        	<br>
        		<h4 style="text-align: left;">&nbsp비밀게시판 <span class="badge bg-secondary"></span></h4>
        		<hr>
            	<!-- 상위구획 10 : 실사용 공간 -->
	       		<!-- 실 판매창 -->
	       		<div class="container">
				  <div class="row">
				 
				 	<%
	    		 		BbsDAO bbsDAO = new BbsDAO();
						ArrayList<Bbs> list= bbsDAO.bgetList(pageNumber);
						for(int i = 0; i < list.size(); i++) {
							String pick;
							if(list.get(i).getBbsType() == 1){
		    		 			pick = "코딩";
		    		 		}else if(list.get(i).getBbsType() == 2){
		    		 			pick = "잡담";
		    		 		}else pick = "비밀";
					%>
					
					<div class="col-3">
					  <div class="card" style="width: 100%; height: 100%;">
					    <img src=".\\fileSave\\<%=list.get(i).getPicture() %>" class="card-img-top" alt=<%=list.get(i).getPicture() %> style="height: 130px;">
					    <div class="card-body">
					      <p class="card-text"><%=pick %>게시판</p>
					      <h5 class="card-title"><%= list.get(i).getBbsTitle() %></h5>
					      <p class="card-text"><%= list.get(i).getDate().substring(2,4)+ "." + list.get(i).getDate().substring(5,7) + "." + list.get(i).getDate().substring(8,11) + list.get(i).getDate().substring(11, 13) + ":" + list.get(i).getDate().substring(14,16) %></p>
					      <a href="view.jsp?bbsID=<%= list.get(i).getBbsID()%>" class="btn btn-primary">Go!</a>
					    </div>
					  </div>
					</div>
					<%
						}
					%>
				    
				    
				  </div>
				</div>
	       		<br>
	       		<br>
	       		<!-- 넘버링 -->
	       		<%
	       			int pageTen = pageNumber-(pageNumber%10);
	       			if(pageTen == pageNumber) pageTen -= 10;
	       			BbsDAO bb = new BbsDAO();
	       		%>
				<nav aria-label="Page navigation example">
				  <ul class="pagination justify-content-center">
				  <% if(pageNumber > 10) { %>
				    <li class="page-item disabled">
				      <a class="page-link">이전</a>
				    </li>
				    <%} %>
					<%
						for(int i = 0; i<10; i++) {
						if(bb.bnextPage(pageTen+1+i)){
					%>
				    <li class="page-item"><a class="page-link  <% if((pageTen+1+i) == pageNumber){%> active <%} %>" href="csound.jsp?pageNumber=<%=pageTen+1+i %>"><%=pageTen+1+i %></a></li>
				   <%}
					} if(bb.bnextPage(pageTen+11)) {
					%>
				    <li class="page-item">
				      <a class="page-link" href="csound.jsp?pageNumber=<%=pageTen+11 %>>">다음</a>
				    </li>
				    <%
				    	}
					%>
				  </ul>
				</nav>
        	</div>
    	</div>
	</div>
	
	<br>
	<br>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous"></script>
</body>
</html>